/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common;

import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.client.sound.ContinuousSound;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.skills.TreasureHunterSkill;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.world.LootStashes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LootStashDetectorHandler {
    private static final Map<UUID, DetectionData> DATA = new HashMap<UUID, DetectionData>();
    private static int cacheClearScheduler;

    public static void initiateUsing(PlayerEntity player) {
        DATA.put(player.func_110124_au(), new DetectionData());
        if (!player.field_70170_p.field_72995_K) {
            LootStashes.addTracker((ServerPlayerEntity)player);
        }
    }

    public static boolean isUsing(UUID uuid) {
        return DATA.containsKey(uuid);
    }

    public static void stopUsing(UUID uuid) {
        DATA.remove(uuid);
        LootStashes.clearTracker(uuid);
    }

    public static DetectionData getData(UUID uuid) {
        return DATA.computeIfAbsent(uuid, k -> new DetectionData());
    }

    @SubscribeEvent
    public void tickPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        UUID uuid = player.func_110124_au();
        DetectionData data = DATA.get(uuid);
        if (data == null) {
            return;
        }
        this.tickPlayer(player, data);
    }

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || --cacheClearScheduler > 0) {
            return;
        }
        cacheClearScheduler = Interval.minutes(5).valueIn(Interval.Unit.TICK);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PlayerList playerList = server.func_184103_al();
        Set<UUID> uuids = Collections.unmodifiableSet(DATA.keySet());
        for (UUID uuid : uuids) {
            ServerPlayerEntity player = playerList.func_177451_a(uuid);
            if (player != null) continue;
            this.remove(uuid);
        }
    }

    private void tickPlayer(PlayerEntity player, DetectionData data) {
        ItemStack stack = this.getStashDetector(player);
        if (stack.func_190926_b() || stack.func_77952_i() >= stack.func_77958_k()) {
            this.remove(player.func_110124_au());
            data.setTrackedLocation(null);
        }
        if (player.field_70170_p.field_72995_K) {
            this.tickPlayerClient(player, data);
        } else {
            this.tickPlayerServer(player, data, stack);
        }
    }

    private void tickPlayerClient(PlayerEntity player, DetectionData data) {
        data.tickClient(player);
    }

    private void tickPlayerServer(PlayerEntity player, DetectionData data, ItemStack stack) {
        if (data.increaseTimer()) {
            data.resetTimer();
            stack.func_96631_a(1, player.func_70681_au(), (ServerPlayerEntity)player);
            if (stack.func_77952_i() == stack.func_77958_k()) {
                this.remove(player.func_110124_au());
            }
        }
    }

    private void remove(UUID uuid) {
        DATA.remove(uuid);
        LootStashes.clearTracker(uuid);
    }

    private ItemStack getStashDetector(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (this.isStashDetector(stack)) {
            return stack;
        }
        stack = player.func_184592_cb();
        if (this.isStashDetector(stack)) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isStashDetector(ItemStack stack) {
        return stack.func_77973_b() == ModItems.STASH_DETECTOR;
    }

    public static enum Status {
        LOCATED,
        NEARBY,
        UNDETECTED;

    }

    public static class DetectionData {
        private int updateTimer;
        private Status lastStatus;
        private Status status = Status.UNDETECTED;
        private BlockPos trackedLocation;
        private int soundTimer;
        private int lightSwitchTimerHalf;
        private float diodeIntesity;
        @OnlyIn(value=Dist.CLIENT)
        private ContinuousSound sound;

        public void setTrackedLocation(BlockPos trackedLocation) {
            this.trackedLocation = trackedLocation;
        }

        public Status getStatus() {
            return this.status;
        }

        public float getDiodeIntesity() {
            return this.diodeIntesity;
        }

        public void resetTimer() {
            this.updateTimer = 0;
        }

        public boolean increaseTimer() {
            return ++this.updateTimer > 20;
        }

        public void tickClient(PlayerEntity player) {
            this.lastStatus = this.status;
            if (this.trackedLocation == null) {
                this.status = Status.UNDETECTED;
            } else {
                double distance = this.getDistance(player);
                IPlayerData data = PlayerData.getUnsafe(player);
                ISkillProvider provider = data.getSkillProvider();
                TreasureHunterSkill skill = SkillUtil.getTopHierarchySkill(Skills.TREASURE_HUNTER_I, provider);
                if (skill == null) {
                    this.status = Status.UNDETECTED;
                    return;
                }
                TreasureHunterSkill.DetectionRadius radius = skill.getRadius();
                this.status = radius.getStatusByDistance(distance);
                if (this.status == Status.NEARBY) {
                    int soundScheduler;
                    float soundDelay = radius.getSoundIntensity(distance);
                    int n = soundScheduler = soundDelay == 1.0f ? -1 : 2 + (int)(soundDelay * 28.0f);
                    if (soundScheduler > 0) {
                        if (--this.soundTimer <= 0) {
                            this.soundTimer = soundScheduler;
                            this.lightSwitchTimerHalf = soundScheduler;
                            player.func_184185_a(ModSounds.DETECTOR_BEEP, 0.4f, 1.0f);
                        }
                        this.diodeIntesity = (float)this.soundTimer / (float)this.lightSwitchTimerHalf;
                    }
                }
            }
            if (this.lastStatus != this.status) {
                this.onStatusChanged();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private void onStatusChanged() {
            boolean startSound = this.status == Status.LOCATED;
            Minecraft mc = Minecraft.func_71410_x();
            SoundHandler handler = mc.func_147118_V();
            if (this.sound != null) {
                handler.func_147683_b((ISound)this.sound);
            }
            if (startSound) {
                this.sound = new ContinuousSound(ModSounds.DETECTOR_BEEP_LONG, SoundCategory.MASTER, player -> LootStashDetectorHandler.isUsing(player.func_110124_au()));
                handler.func_147682_a((ISound)this.sound);
            }
        }

        private double getDistance(PlayerEntity player) {
            double x = player.func_226277_ct_() - (double)this.trackedLocation.func_177958_n();
            double z = player.func_226281_cx_() - (double)this.trackedLocation.func_177952_p();
            return Math.sqrt(x * x + z * z);
        }
    }
}

